// Program to find the Resonating frequency of a Tuning fork
// using spectrum of the signal
//
//OS: windows 7
//Scilab: 5.5.2
//
clc;
close;
clear;
[y,Fs] = wavread('C:\Users\ACER\Desktop\Freq512Hz.wav');
y=y(200:1900); // considering only a segment to reduce the amount of computation
t=(0:length(y)-1)/Fs;
subplot(211)
plot(t,y)
xlabel('Time in seconds')
title('Original signal')
Y=abs(fft(y));  //find the fourier transform

l = length(Y)/2;
f = (0:(l-1))*Fs/(2*l); //modify the x axis to represent frequency instead of samples

abs_fft = abs(Y(1:l));
subplot(212)
plot(f,abs_fft);   //plot magnitude of fourier transform
title('Fourier Transform of signal')
xlabel('Frequency')
ylabel('Amplitude')

peak = max(abs_fft); //find the first maxima of the spectrum
peakfreq = [f(abs_fft == peak)]
disp('Resonating frequency of given tuning fork (in Hz): ');
disp(peakfreq); //display the contained frequencies
